# setOrcaCheckpointConfig {#setOrcaCheckpointConfig}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setOrcaCheckpointConfig(name, configMap)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**configMap** is a dictionary specifying the detailed configuration. The keys and their settings are as shown in the table below.

|key|Description|Value Range|Default|
|---|-----------|-----------|-------|
|enable|Whether to enable Checkpoint|true/false|false|
|interval|Time interval to trigger Checkpoint, in milliseconds|\[10 seconds, 1 year\]|1 hour|
|timeout|Timeout for Checkpoint. If Checkpoint is not completed within the specified time, it will be considered failed, in milliseconds|\[1 second, 1 hour\]|10 minutes|
|alignedTimeout|Timeout for Barrier alignment. If alignment is not completed within the specified time, the Checkpoint will be considered failed, in milliseconds|\[100 milliseconds, 1 hour\]|10 minutes|
|minIntervalBetweenCkpt|Minimum time interval between the completion of the last Checkpoint and the initiation of the next Checkpoint|\[0, 1 year\]|0|
|consecutiveFailures|Maximum number of consecutive Checkpoint failures. If exceeded, the status of the entire streaming graph will be switched to ERROR.|\[0, 102400\]|3|
|maxConcurrentCheckpoints|Maximum number of concurrent Checkpoints allowed. Please note that allowing concurrent Checkpoints may impact running streaming jobs.|\[1, 102400\]|1|
|maxRetainedCheckpoints|The system will periodically clean up historical Checkpoint data. This parameter sets the maximum number of latest Checkpoints to retain.|\[1, 1024\]|3|

## Details {#details}

Dynamically modify the checkpoint configuration.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
ckptConfig = {
    "enable":true,
    "interval": 10000,
    "timeout": 36000,
    "maxConcurrentCheckpoints": 1
};
setOrcaCheckpointConfig("streamGraph1", ckptConfig)
```

