# setMaxConnections {#setmaxconnections}

## Syntax {#section_epc_b32_czb .section}

`setMaxConnections(newValue)`

## Arguments {#section_lbc_c32_czb .section}

**newValue** is a positive integer smaller than 2^16 \(65536\).

## Details {#section_f45_c32_czb .section}

Modify the maximum number of connections to the current node online. This command can only be executed by an administrator.

You can check if the modification is successful from the field *maxConnections* returned by executing function [getClusterPerf](../g/getClusterPerf.md) on the controller.

**Note:**

-   The value specified by *newValue* must be greater than the current maximum number of connections, otherwise, it cannot take effect.

-   The modified configuration will expire after the cluster is rebooted. To make it permanent, change the configuration parameter *maxConnections*.

-   The function `getClusterPerf` has a delay in getting the node information.


**Parent topic:**[Functions](../../Functions/category.md)

