# setIndexedSeries! {#setindexedseries}

## Syntax {#syntax}

`setIndexedSeries!(X, [on=true])`

## Arguments {#arguments}

**X** is a matrix with row labels and only one column. The row labels must be monotonically increasing with no duplicate values.

**on** \(optional\) is a Boolean value indicating the conversion between a matrix and an indexed series. The default value is true, indicating the conversion from a matrix to an indexed series. Set to false for the opposite conversion.

## Details {#details}

Convert a single column matrix with row labels into an indexed series.

## Examples {#examples}

```
s = matrix(1..10).rename!(2012.01.01..2012.01.10, ).setIndexedSeries!();
s;
```

||\#0|
|---|---|
|2012.01.01|1|
|2012.01.02|2|
|2012.01.03|3|
|2012.01.04|4|
|2012.01.05|5|
|2012.01.06|6|
|2012.01.07|7|
|2012.01.08|8|
|2012.01.09|9|
|2012.01.10|10|

