# setIndexedMatrix! {#setindexedmatrix}

## Syntax {#syntax}

`setIndexedMatrix!(X, [on=true])`

## Arguments {#arguments}

**X** is a matrix with row labels and column labels. Row labels and column labels must be monotonically increasing with no duplicate values.

**on** \(optional\) is a Boolean value indicating the conversion between a matrix and an indexed matrix. The default value is true, indicating the conversion from a matrix to an indexed matrix. Set to false for the opposite conversion.

## Details {#details}

Set the labels of the rows and columns of a matrix as the indexes.

## Examples {#examples}

```
m=matrix(1..5, 11..15)
m.rename!(2020.01.01..2020.01.05, `A`B)
m.setIndexedMatrix!();
```

||A|B|
|---|---|---|
|2020.01.01|1|11|
|2020.01.02|2|12|
|2020.01.03|3|13|
|2020.01.04|4|14|
|2020.01.05|5|15|

