# setGpFitnessFunc {#setGpFitnessFunc}

**Note:** This function is not supported by Community Edition. You can [get a trial](https://dolphindb.com/product#downloads-down) of Shark from DolphinDB official website.

## Syntax {#Syntax .section}

`setGpFitnessFunc(engine, func)`

## Arguments {#Arguments .section}

**engine** is the engine object returned by `createGPLearnEngine`.

**func** is the fitness function, which can be:

-   A FUNCTIONDEF scalar, specifying a built-in function supported by *fitnessFunc*of `createGPLearnEngine`. It must be 'mse', 'rmse', 'pearson', 'spearmanr', or 'mae'.

-   A user-defined function with a floating-point return value. It takes two input arguments, the first represents the factor calculation result, and the second represents the predicted value. Currently it does not support complex assignment, `if` or `for` statement. Only `return` statement can be used to return a combination of the supported fitness function and the training function. For example:

    ``` {#codeblock_ind_lzk_2bc}
    def f(x, y){
      return mse(x+y,y)
    }
    ```

    A user-defined fitness function can be combined with a helper function \(as shown below\) to pre-process the data before calculation.

    |Function|Num of Args|
    |--------|-----------|
    |clip\(X,Y,Z\)|3|
    |zscore\(x\)|1|
    |mad\(X, \[useMedian=false\]\)|1|
    |med\(x\)|1|
    |mean\(x\)|1|
    |corr\(X,Y\)|2|


## Details {#Details .section}

Set fitness function for the GPLearn engine.

## Examples {#section_kzx_3hz_2bc .section}

Set fitness function for the GPLearn engine.

``` {#codeblock_iwc_khz_2bc}
def f(x, y){
  return mse(x+y,y)
}
setGpFitnessFunc(engine,f)
```

**Parent topic:**[Functions](../../Functions/category.md)

