# setDynamicConfig {#setDynamicConfig}

## Syntax {#Syntax .section}

`setDynamicConfig(configName, configValue)`

## Arguments {#Arguments .section}

**configName** is a STRING scalar indicating the name of configuration parameter to be modified.

**configValue** is a scalar indicating the new value to be set.

## Details {#Details .section}

Modify the specified configuration parameter online.

**Note:** The modified configuration is only valid for the current node, and will expire after the system restarts. To make it permanent, please change the configuration parameter in configuration file*.*

The following are supported configuration parameters \(for detailed usage, see [Configuration](../../Database/Configuration/reference.md)\):

*enableMultiThreadMerge*, enableNullSafeJoin, *logLevel*, *maxBlockSizeForReservedMemory*, *maxConnections*, *memLimitOfQueryResult*, *memLimitOfTaskGroupResult*, *maxMemSize*, *maxPartitionNumPerQuery*, *memLimitOfTempResult*, *OLAPCacheEngineSize*, *recoveryWorkers*, *reservedMemSize*,*dfsChunkNodeHeartBeatTimeout*, *TSDBCacheEngineSize*, *TSDBVectorIndexCacheSize*, *memLimitOfAllTempResults*.

## Examples {#Examples .section}

``` {#codeblock_cct_ycf_c2c}
setDynamicConfig("maxMemSize", 8);
setDynamicConfig("maxConnections", 4096);
```

Related functions: [getDynamicConfig](../g/getDynamicConfig.md)

**Parent topic:**[Functions](../../Functions/category.md)

