# setColumnarTuple! {#setcolumnartuple}

## Syntax {#section_yfr_lh2_czb .section}

`setColumnarTuple!(X, [on=true])`

## Arguments {#section_fz3_mh2_czb .section}

**X** is a tuple of vectors or scalars of the same type.

**on** is a Boolean value indicating the conversion between tuple and columnar tuple. The default value is true, indicating the conversion from tuple to columnar tuple; False indicates the opposite operation.

## Details {#section_kvb_nh2_czb .section}

This function is used for the conversion between tuple and columnar tuple.

## Examples {#section_idb_4h2_czb .section}

``` {#codeblock_byt_4h2_czb}
tp = [[1,2,3], [4,5,6], [7,8]]
isColumnarTuple(tp)
// output: false

tp.setColumnarTuple!()
isColumnarTuple(tp)
// output: true
 
t = table(1..5 as id, [`a`a,`b`a,`c, `f`e, `g] as val)
isColumnarTuple(t.val)
// output: true

t1 = t.val.setColumnarTuple!(false)
isColumnarTuple(t1)
// output: false
```

**Parent topic:**[Functions](../../Functions/category.md)

