# setColumnComment {#setcolumncomment}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setColumnComment(table, columnComments)`

## Arguments {#arguments}

**table** is a DFS tableor MVCC table.

**columnComments** is a dictionary. Its keys are table columns and values are comments for each column.

## Details {#details}

Add comments to columns of a DFS tableor an MVCC table. Use function [schema](schema.md) to view column comments.

## Examples {#examples}

```
n=1000000
sym=rand(`A`B`C`D`E`F,n)
date=rand(2019.06.01..2019.06.10,n)
open=rand(100.0,n)
high=rand(200.0,n)
close=rand(200.0,n)
pre_close=rand(200.0,n)
change=rand(100.0,n)
vol=rand(10000,n)
amount=rand(100000.0,n)
t=table(sym,date,open,high,close,pre_close,change,vol,amount);

db1=database("",VALUE,2019.06.01..2019.06.10)
db2=database("",VALUE,`A`B`C`D`E`F)
db=database("dfs://db1",COMPO,[db1,db2])
pt=db.createPartitionedTable(t,`pt,`date`sym).append!(t);

setColumnComment(pt,{sym:"stock ticker", date:"trading date", open:"open price", high:"highest price", low:"lowest price", close:"close price", vol:"trading volume (shares)", amount:"trading volume (dollar)"})
schema(pt).colDefs;
```

|name|typeString|typeInt|comment|
|----|----------|-------|-------|
|sym|SYMBOL|17|stock ticker|
|date|DATE|6|trading date|
|open|DOUBLE|16|open price|
|high|DOUBLE|16|highest price|
|close|DOUBLE|16|close price|
|vol|INT|4|trading volume \(shares\)|
|amount|DOUBLE|16|trading volume \(dollar\)|

```
id=`XOM`GS`AAPL
x=102.1 33.4 73.6
mt = mvccTable(id, x);
setColumnComment(mt, {id:"identifier"})
schema(mt).colDefs
```

|name|typeString|typeInt|extra|comment|
|----|----------|-------|-----|-------|
|id|STRING|18||identifier|
|x|DOUBLE|16|||

