# setCacheEngineMemSize {#setolapcacheenginesize}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setCacheEngineMemSize(memSize)`

## Arguments {#arguments}

**memSize** is a numeric scalar \(in GB\). It must be greater than 0 and less than *maxMemSize* \* 0.75.

## Details {#details}

Modify the capacity of the OLAP cache engine online. In a cluster, this command can only be executed by the admin on a data node or compute node. Please make sure the cache engine is enabled by specifying configuration parameter *chunkCacheEngineMemSize* before execution.

-   Scenario: If the cache engine is enabled, the system will first write the data to the cache. Only when the amount of cached data reaches 30% of *chunkCacheEngineMemSize* will it be written to disk. If the configuration parameter is set too low, massive concurrent writes may take up the cache engine capacity quickly and cause the writing process stuck. In this case, execute the command to online modify the cache engine capacity to ensure that the writes continue.

-   You can obtain the real-time status of the cache engine with function `getOLAPCacheEngineSize` to check if the modification takes effect online.


**Note:**

The modified configuration will expire after the cluster is rebooted. To make it permanent, please change the configuration parameter *chunkCacheEngineMemSize*.

Related function: [getOLAPCacheEngineSize](../g/getOLAPCacheEngineSize.md)

