# seq {#seq}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`seq(start, end)` or `start..end`

## Arguments {#arguments}

**start** and **end** must be integers or temporal values.

## Details {#details}

Returns a vector starting from *start* and ending at *end*. The step between two adjacent elements is 1.

Note: If both *start* and *end* are integral or temporal NULLs, the function returns an empty vector.

## Examples {#examples}

```
x=0..3;
x;
// output: [0,1,2,3]

1..3+1;
// output: [2,3,4]

11..1;
// output: [11,10,9,8,7,6,5,4,3,2,1]

seq(3,1);
// output: [3,2,1]

2015.01M..2015.12M;
// output: [2015.01M,2015.02M,2015.03M,2015.04M,2015.05M,2015.06M,2015.07M,2015.08M,2015.09M,2015.10M,2015.11M,2015.12M]

2016.01.01..2016.01.07;
// output: [2016.01.01,2016.01.02,2016.01.03,2016.01.04,2016.01.05,2016.01.06,2016.01.07]
```

