# semiannualEnd {#semiannualEnd}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`semiannualEnd(X, [endingMonth=12], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**endingMonth** is an integer between 1 and 12 indicating a month. The default value is 1.

**offset** is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** is a positive integer. The default value is 1.

## Details {#details}

Return the first day of the semiannual period that *X* belongs to. The first months of each semiannual period is determined by *startingMonth*.

If the parameter *offset* is specified, the result is updated every *n* semiannual periods. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
semiannualEnd(2025.08.10);
// output: 2025.12.31

semiannualEnd(2025.10.10 10:10:10.008, 3);
// output: 2026.03.31

date=[2024.04.20,2024.05.31,2024.07.07,2024.10.24,2024.12.20,2025.01.19,2025.04.24,2025.04.28,2025.10.06,2026.01.06]
sym = take(`AAA,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, sym, qty, price);

select avg(price),sum(qty) from t1 group by semiannualEnd(date, 12, 2024.01.01, 2)
```

|semiannualEnd\_date|avg\_price|sum\_qty|
|-------------------|----------|--------|
|2024.06.30|39.53|4,100|
|2025.06.30|85.13666666666667|21,300|
|2026.06.30|51.835|13,300|

