# schur {#schur}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`schur(obj, [sort])`

## Arguments {#arguments}

**obj** is a square matrix.

**sort** \(optional\) is a string. It is used to reorder the factors according to a specified ordering of the eigenvalues. The value can be 'lhp' \(eigenvalue is a negative real number\), 'rhp' \(eigenvalue is a positive real number\), 'iuc' \(the absolute value of a complex eigenvalue&lt;=1.0\), 'ouc' \(the absolute value of a complex eigenvalue&gt;1.0\).

## Details {#details}

Compute the Schur decomposition of a square matrix.

Suppose the input is the square matrix A:

-   If *sort* is not specified, return 2 matrices: T \(Schur form of A, an upper triangular matrix\) and an unitary matrix Z \(the transpose matrix of Z is equal to its inverse matrix\), so that A = Z\*T\*Z-1.
-   If *sort* is specified, the function will also return an integer indicating the number of eigenvalues that meet the sorting conditions.

## Examples {#examples}

```
m=matrix([[0,0,1],[2,1,0],[2,2,1]]);
T,Z=schur(m)
T;
```

|\#0|\#1|\#2|
|---|---|---|
|2.658967|1.424405|-1.929334|
|0|-0.329484|-0.490637|
|0|1.311789|-0.329484|

```
Z
```

|\#0|\#1|\#2|
|---|---|---|
|0.727116|-0.601562|0.330796|
|0.528394|0.798019|0.289768|
|0.438294|0.035904|-0.898114|

```
T,Z,s=schur(m, 'lhp');
T;
```

|\#0|\#1|\#2|
|---|---|---|
|-0.329484|1.570974|2.251318|
|-0.40969|-0.329484|-0.092398|
|0|0|2.658967|

```
Z
```

|\#0|\#1|\#2|
|---|---|---|
|0.703818|-0.632169|0.324042|
|0.509043|0.766983|0.390655|
|-0.495495|-0.109999|0.861618|

```
s
// output: 2
T,Z,s=schur(m, 'rhp');

s;
// output: 1

m=matrix([[0,0,9],[-2,1,0],[2,2,1]]);
T,Z,s=schur(m, 'iuc');
s;
// output: 0

T,Z,s=schur(m, 'ouc');
s;
// output: 1
```

