# scheduleJob {#schedulejob}

## Syntax {#syntax}

`scheduleJob(jobId, jobDesc, jobFunc, scheduleTime, startDate, endDate, frequency, [days], [onComplete], [priority], [parallelism])`

## Arguments {#arguments}

**jobId** is a string indicating the job ID.

**jobDesc** is a string indicating the job description.

**jobFunc** is a function with no parameters. It is usually a partial application. Note that if the *jobFunc* is a user-defined function, it can only take scalars, pairs or regular vectors as default parameters.

**scheduleTime** is a scalar/vector of MINUTE type. The minimum time interval to execute the next task is 5 minutes.

**startDate** is a scalar of DATE type.

**endDate** is a scalar of DATE type.

**frequency** is of CHAR type. It can take one of the following 3 values: 'D' for daily, 'W' for weekly, and 'M' for monthly.

**days** \(optional\) is an integer scalar/vector indicating which day\(s\) of a week or a month to run the scheduled job. This optional parameter is required if frequency=W or M. If frequency=W, days can take the following values: 0 \(Sunday\), 1 \(Monday\), ...., 5 \(Firday\), 6 \(Saturday\).

**onComplete** \(optional\) is a callback function with 4 parameters. For details please refer to the last example below. After the scheduled job is executed \(even if an error occurs\), the callback function is executed. It can be used to send out emails regarding the execution.

**priority** \(optional\) is an integer from 0 to 8 indicating the priority of the job. The default value is 4.

**parallelism** \(optional\) is an integer from 0 to 8 indicating the maximum number of workers allocated to the job. The default value is 2.

**Note**: The *priority* and *parallelism* of the job are limited by the maximum values \(*maxPriority*and *maxParallelism*\) set by [setMaxJobPriority](setMaxJobPriority.md) and [setMaxJobParallelism](setMaxJobParallelism.md), respectively. The final priority and parallelism are `min(priority, maxPriority)` and `min(parallelism, maxParallelism)`.

## Details {#details}

Execute a job at specified time and with specified *frequency*. Return the job ID of the scheduled job. If *jobId* is different from the job IDs of all the existing scheduled jobs, the system returns *jobId*. Otherwise, append suffix of the current date, or "000", "001", ..... or both to *jobId* until a unique scheduled job ID is found. Please use [getRecentJobs](../g/getRecentJobs.md) to view the recently finished scheduled jobs.

The messages produced in the execution of the scheduled job are saved in *jobId.msg*; if the scheduled job returns any value, it is saved in *jobId.object*. *jobId.msg* and *jobId.object* are saved under the folder of *batchJobs*. We can use functions [getJobMessage](../g/getJobMessage.md) and [getJobReturn](../g/getJobReturn.md) to view these 2 files respectively.

## Examples {#examples}

Schedule to run a function:

```
def f():1+2;
scheduleJob(jobId=`daily, jobDesc="Daily Job 1", jobFunc=f, scheduleTime=17:23m, startDate=2018.01.01, endDate=2018.12.31, frequency='D');
scheduleJob(jobId=`weekly, jobDesc="Weekly Job", jobFunc=f, scheduleTime=17:30m, startDate=2018.01.01, endDate=2018.12.31, frequency='W', days=2);
```

Schedule to run a script:

```
scheduleJob(jobId=`monthly, jobDesc="Monthly Job 1", jobFunc=run{"monthlyJob.dos"}, scheduleTime=17:23m, startDate=2018.01.01, endDate=2018.12.31, frequency='M', days=1);
```

Here we use a partial application run\{&lt;script&gt;\} as this parameter needs to be a function with no arguments.

```
getJobMessage(`daily);

018-02-08 17:23:27.166296 Start the job [daily]: Daily Job 1

018-02-08 17:23:27.167303 The job is done.


 getJobReturn(`daily);


```

We can schedule to run the same job multiple times a day:

```
scheduleJob(jobId=`Trading, jobDesc="Generate Trading Tickets", jobFunc=run{"TradingTickets.dos"}, scheduleTime=[09:25m, 12:00m, 02:00m, 15:50m], startDate=2018.01.01, endDate=2018.12.31, frequency='D');
```

In this case, each time this scheduled job is executed, the job ID is different. The job IDs for the first day is "Trading", "Trading20180101000", "Trading001", "Trading002" for the first day, and "Trading003", "Trading004", "Trading005", "Trading006" for the second day, etc.

To run the same job multiple times a day only on weekdays:

```
scheduleJob(jobId=`PnL, jobDesc="Calculate Profit & Loss", jobFunc=run{"PnL.dos"}, scheduleTime=[12:00m, 02:00m, 14:50m], startDate=2018.01.01, endDate=2018.12.31, frequency='W', days=[1,2,3,4,5]);
```

Send an email after the execution of the scheduled job. Please install the HttpClient plugin before running the following script.

```
def sendEmail(jobId, jobDesc, success, result){
  desc = "jobId=" + jobId + " jobDesc=" + jobDesc
  if(success){
  desc += " successful " + result
    res = httpClient::sendEmail('patrick.mahomes@dolphindb.com','password','andy.reid@dolphindb.com','This is a subject',desc)
  }
  else{
  desc += " with error: " + result
    res = httpClient::sendEmail('patrick.mahomes@dolphindb.com','password','andy.reid@dolphindb.com','This is a subject',desc)
  }
}
scheduleJob(jobId=`PnL, jobDesc="Calculate Profit & Loss", jobFunc=run{"PnL.dos"}, scheduleTime=[12:00m, 02:00m, 14:50m], startDate=2018.01.01, endDate=2018.12.31, frequency='W', days=[1,2,3,4,5], onComplete=sendEmail);
```

