# saveText {#savetext}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`saveText(obj, filename, [delimiter=','], [append=false], [header=true], [bom=''])`

## Arguments {#arguments}

**obj** can be a table/matrix/vector/metacode of SQL statements. When *obj* is the metacode of SQL statements, multiple workers are allocated to read the data concurrently, and the data is written to the file with another worker. In other cases, data queries and writes are handled by the current worker.

**filename** is a string indicating the absolute path and name of the output file. Currently the output file can only be saved in *.csv* format.

**delimiter** \(optional\) is the table column separator. The system uses comma as the default delimiter.

**append** \(optional\) is a Boolean value indicating whether to append to \(true\) or overwrite \(false\) the output file if it exists already.

**header** \(optional\) is a BOOLEAN indicating whether to save the column names in the output file when obj is a table. The default value is true. Please note that this parameter has no effect when this command is used for appending data to an existing non-empty file \(i.e., when append = true\).

**bom** \(optional\) is a case-insensitive STRING scalar that determines whether to include Byte order mark \(BOM\) in output CSV files. Currently, only "UTF-8" is supported. It defaults to ' '.

## Details {#details}

Save DolphinDB variables or data queried by SQL statement as a text file on disk. Compared with [saveTable](saveTable.md), `saveText` requires more disk space and time.

## Examples {#examples}

*Example 1*

```
n=20000000
syms=`IBM`C`MS`MSFT`JPM`ORCL`GE`EBAY`GOOG`FORD`GS
timestamp=09:30:00+rand(18000,n)
sym=rand(syms,n)
qty=100*(1+rand(100,n))
price=5.0+rand(100.0,n)
t1=table(timestamp,sym,qty,price);

timer saveText(t1, "c:/test/trades.txt");
// Time elapsed: 191488 ms
```

*Example 2*

```
n=100
t1=table(1..n as id, rand(1000, n) as x)
saveText(t1, "C:/DolphinDB/Data/t.csv",,1)
t2=table((n+1)..(2*n) as id, rand(1000, n) as x)
saveText(t2, "C:/DolphinDB/Data/t.csv",,1)
t = loadText("C:/DolphinDB/Data/t.csv")
select count(*) from t;
// output: 200
```

*Example 3* Save a DFS table as a text file

```
if(existsDatabase("dfs://testdb")){

  dropDatabase("dfs://testdb")
}
n=3000
ticker = rand(`MSFT`GOOG`FB`ORCL`IBM`PPT`AZH`ILM`ANZ,n);
id = rand(`A`B`C, n)
x=rand(1.0, n)
t=table(ticker, id, x)
db=database(directory="dfs://testdb", partitionType=HASH, partitionScheme=[STRING, 5])
pt = db.createPartitionedTable(t, `pt, `ticker)
pt.append!(t)

saveText(<select * from pt>, "/home/data/pt.txt")
```

