# saveTable {#savetable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`saveTable(dbHandle, table, [tableName], [append=false], [compression=false])`

## Arguments {#arguments}

**dbHandle** is a DolphinDB database handle.

**table** is the table in memory to be saved.

**tableName** \(optional\) is a string indicating the desired name for the saved table. If unspecified, the saved table has the same name as the table in memory.

**append** \(optional\) is the appending mode. When it is set to *true*, the new table will be appended to the old table. The default value is *false*.

**compression** \(optional\) is the compression mode. When it is set to *true*, the table will be saved to disk in compression mode. The default setting is *false*.

## Details {#details}

Save a table to an unpartitioned disk table. It must be executed by a logged-in user.

To save a table to a partitioned database, use [createPartitionedTable](../c/createPartitionedTable.md) together with [append!](../a/append!.md) or [tableInsert](../t/tableInsert.md).

**Note:** Disk tables are only used for backup or local computing. Unlike the DFS tables, disk tables do not support access control.

## Examples {#examples}

```
db=database("C:/DolphinDB/Data/db1")
t=table(take(1..10,10000000) as id, rand(10,10000000) as x, rand(10.0,10000000) as y);
```

Save table t to disk:

```
saveTable(db, t);
```

Save table t to disk with name t1:

```
saveTable(db, t, `t1);
```

Save table t to disk with name t2 and with appending mode:

```
saveTable(db, t, `t2, true);
```

Save table t to disk with name t3 and with compression mode:

```
saveTable(db, t, `t3, false, true);
```

