# saveDualPartition {#savedualpartition}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`saveDualPartition(dbHandle1, dbHandle2, table, tableName, partitionColumn1, partitionColumn2, [compression=false])`

## Arguments {#arguments}

**dbHandle1** is the database handle of the first level partition.

**dbHandle2** is the database handle of the second level partition.

**table** is the table in memory to be saved.

**tableName** is a string indicating the desired name of the saved partitioned table.

**partitionColumn1** is a string indicating the partitioning column of the first level partition.

**partitionColumn2** is a string indicating the partitioning column of the second level partition.

**compression** \(optional\) is a Boolean variable. It sets the compression mode. When it is set to true, the table will be saved to disk in compression mode. The default value is false.

## Details {#details}

Save a table in the local node before sharing it to other nodes to form a dual partition database. It must be executed by a logged-in user.

It is used together with statement [share](../../Programming/ProgrammingStatements/share.md). If the partition and a table already exist, the function will append the new data to the existing table.

## Examples {#examples}

```
n=1000000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(1.0, n)
t=table(ID, date, x);

hdb = database("C:/DolphinDB/Data/dualDB", RANGE,  0 5 10)
vdb = database(, VALUE, dates)
saveDualPartition(hdb, vdb, t, `tDualPartition, `ID, `date)
```

