# saveAsNpy {#saveasnpy}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`saveAsNpy(obj, fileName)`

## Arguments {#arguments}

**obj** is a numeric vector/matrix.

**fileName** is the path and name of the output file.

## Details {#details}

Save a vector/matrix in DolphinDB as an npy file. It must be executed by a logged-in user.

Note: Null values in *obj* will be converted to negative infinity \(-inf\).

## Examples {#examples}

```
v = 1..1000
v.saveAsNpy("C:/DolphinDB/intVec.npy")

m = (1..1000 + 0.5)$20:50
m.saveAsNpy("C:/DolphinDB/doubleMat.npy")
```

Load files in python:

```
import numpy as np
v = np.load("C:/DolphinDB/intVec.npy")
m = np.load("C:/DolphinDB/doubleMat.npy")
```

Related function: [loadNpy](../l/loadNpy.md)

