# StreamGraph::haSource {#StreamGraph_haSource}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`StreamGraph::haSource(name, colNames, colTypes, raftGroup, cacheLimit, [retentionMinutes=1440])`

## Details {#details}

Creates a high-availability stream table. For details, see [haStreamTable](../h/haStreamTable.md).

**Return value**: A DStream object.

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**colNames** is a STRING vector of column names.

**colTypes** is a STRING vector of data types. It can use either the reserved words for data types or corresponding strings.

**raftGroup** can be either an integer greater than 1 or a string.

-   Integer: represents the raft group ID.
-   String: represents a raft group alias, which must be preconfigured via *streamingRaftGroupAliases*.

**cacheLimit** is an integer representing the maximum number of rows of the high-availability stream table to be kept in memory. If *cacheLimit*&gt;1000, it is automatically adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in terms of minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file only keeps data in the past 24 hours.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("orca")) {
	createCatalog("orca")
}
go
use catalog orca

g = createStreamGraph("indicators")
g.haSource("ha_table", 1:0, `time`symbol`price`volume, [DATETIME,SYMBOL,DOUBLE,LONG], 3, 50000)
```

