# run {#run}

## Syntax {#syntax}

`run(scriptFile, [newSession=false], [clean=true])`

## Arguments {#arguments}

**scriptFile** is the path of the script file.

**newSession** indicates whether to create a new session to execute the script.

**clean** indicates whether to clean the variables in the current session. The default value is true, meaning the variables will be cleaned after executing `run`.

## Details {#details}

Execute a saved program. If *newSession* = false, the program runs in the current session. If *newSession* = true, the program file runs in a newly created session which will be closed after finish running the script.

**Note**: It must be executed by a logged-in user. A non-administrator must meet the following conditions to execute the function: \(1\) Obtain the [SCRIPT\_EXEC](../g/grant.md) privilege; \(2\) The configuration item [*strictPermissionMode*](../../Database/Configuration/reference.md) should be set to false \(default\).

## Examples {#examples}

```
run "/home/DolphinDB/test.dos";

d = dict(STRING, ANY)
d["TradePrice"] = 1..1000
// Set the clean parameter to false so that the variable d in the current session will not be cleaned
run("/home/DolphinDB/test.dos", clean=false)
parseExpr("avg(TradePrice)",d).eval()
# output
500.5
```

