# rpc {#rpc}

## Syntax {#syntax}

`rpc(nodeAlias, func, args, ...)`

## Arguments {#arguments}

**nodeAlias** is the alias of a remote node.

**func** is a function. It must not be quoted. The function could be either a built-in function or a user-defined function on the local node.

**args** are function arguments. It does not support dictionaries whose values are function definitions.

## Details {#details}

Call a local function on the specified remote node and return the result to the local node. The function can be either a built-in function or a user defined function on the local node. The system automatically serializes the function definition and the definitions of all dependent functions together with necessary local data to remote node.

Both the calling node and the remote node must be located in the same cluster. Otherwise, we need to use function [remoteRun](remoteRun.md) .

For more details please refer to [Batch Job Management](../../Maintenance/BatchJobManagement.md).

## Examples {#examples}

-   Remote call a user defined function:

    ``` {#codeblock_npm_3lf_czb .python}
    rpc("nodeA", def(x,y):x+y, 10, 15)
    ```

-   Remote call a partial application:

    ``` {#codeblock_fc1_jlf_czb .python}
    rpc("nodeA", getRecentJobs{10})
    ```

-   Remote call a built-in function that quotes a user-defined function:

    ``` {#codeblock_k2q_jlf_czb .python}
    def jobDemo(n){
        s = 0
        for (x in 1 : n) {
           s += sum(sin rand(1.0, 100000000)-0.5)
               print("iteration " + x + " " + s)
    }
    return s
    };
    // the node "DFS_NODE2" is located in the same cluster as the local node.
    rpc("DFS_NODE2", submitJob, "jobDemo3", "job demo", jobDemo, 10);
    // output: jobDemo3
    
    rpc("DFS_NODE2", getJobReturn, "jobDemo3")
    // output: -3426.577521
    ```


