# rpad {#rpad}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rpad(str, length, [pattern])`

## Arguments {#arguments}

**str** is a string scalar or vector. It is the string to pad characters to \(the right-hand side\).

**length** is a positive integer indicating the number of characters to return. If *length* is smaller than the length of *str*, the `rpad` function will truncate *str* to the size of length.

**pattern** \(optional\) is a string scalar. It is the string that will be padded to the right-hand side of str. If it is unspecified, the `rpad` function will pad spaces to the right-side of *str*.

## Details {#details}

Pad the right-side of a string with a specific set of characters.

## Examples {#examples}

```
rpad("Hello",2);
// output: He

rpad(`Hello, 10);
// output: Hello

rpad(`Hello, 12, `0);
// output: Hello0000000
```

