# rowWsum {#rowwsum}

## Syntax {#syntax}

`rowWsum(X, Y)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

Calculate the cumulative weighted sum of *X* by row with *Y* as the weights and return a vector with the same number of rows of *X*.

## Examples {#examples}

```
m1=matrix(2 -1 4, 8 3 2, 9 0 1)
m2=matrix(8 11 10, 8 17 4, 14 6 4)
rowWsum(m1, m2)
// output: [206, 40, 52]

m3=matrix(8 NULL 10, 8 NULL 4, 14 NULL NULL)
rowWsum(m1, m3)
// output: [206, , 48]

a= -10 12.3 4 -8
b= 17.9 9 7.5 -4
c= 5.5 6.4 -7 8
x=array\(DOUBLE\[\],0, 10\).append!\(\[a, b, c\]\)
y=array\(DOUBLE\[\],0, 10\).append!\(\[b, a, c\]\)

rowWsum\(x, y\)
// output: \[0.63, -6.3 , 184.21\]
```

Related function: [wsum](../w/wsum.md)

