# rowOr {#rowor}

## Syntax {#syntax}

`rowOr(args...)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

For each row \(a vector is viewed as a one-column matrix here\), return 1 if there are true elements in each row of the input; otherwise return 0.

## Examples {#examples}

```
m=matrix([true false false, true true true, true true true])
rowOr(m);
// output: [1,1,1]

t1=table(false true true true false as x, false true false true true as y)
rowOr(t1);
// output: [0,1,1,1,1]]

t=table(`AAPL`MS`IBM`IBM`C as sym, 49.6 29.46 29.52 30.02 174.97 as price1, 175.23 50.76 50.32 51.29 26.23 as price2)
select *  from t where rowOr(price1>30, price2>100);
```

|sym|price1|price2|
|---|------|------|
|AAPL|49.6|175.23|
|IBM|30.02|51.29|
|C|174.97|26.23|

Related function: [or](../../Programming/Operators/OperatorReferences/or.md)

