# rowNo {#rowno}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowNo(X)`

## Arguments {#arguments}

**X** is a vector.

## Details {#details}

Return the index position of each row in a table.

## Examples {#examples}

```
team=1 1 1 1 1 2 2 2 2 2
id=1..5 join 2..6
x=11..20\2
t=table(team, id, x)
t;
```

|team|id|x|
|----|---|---|
|1|1|5.5|
|1|2|6|
|1|3|6.5|
|1|4|7|
|1|5|7.5|
|2|2|8|
|2|3|8.5|
|2|4|9|
|2|5|9.5|
|2|6|10|

```
select * from t where rowNo(id)%3=0;
```

|team|id|x|
|----|---|---|
|1|1|5.5|
|1|4|7|
|2|3|8.5|
|2|6|10|

```
update t set teamFirst=(rowNo(id)==0) context by team;
t;
```

|team|id|x|teamFirst|
|----|---|---|---------|
|1|1|5.5|1|
|1|2|6|0|
|1|3|6.5|0|
|1|4|7|0|
|1|5|7.5|0|
|2|2|8|1|
|2|3|8.5|0|
|2|4|9|0|
|2|5|9.5|0|
|2|6|10|0|

