# rowNext {#rownext}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowNext(X)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

For each row in *X*, `rowNext` shifts the elements to the left for one position.

## Examples {#examples}

```
m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL])
rowNext(m)
/* output:
col1        col2    col3
1.5         4.9
4.8     2
5.9
*/

a=array(INT[], 0, 10).append!([1 2 3, 4 5, 6 7 8]);
rowNext(a)
// output: [[2,3,00i],[5,00i],[7,8,00i]]

tp = [[1.3,2.5,2.3], [4.1,5.3,6.2]]
tp.setColumnarTuple!()
rowNext(tp)
// output: [[2.5,2.3,00F],[5.3,6.2,00F]]
```

