# rowMove {#rowmove}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowMove(X, steps)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Arguments {#arguments}

**steps** is an integer indicating the length to shift the row elements of *X*.

-   if *steps* is positive, the elements in each row are shifted to the right by *steps* position\(s\).

-   if *steps* is negative, the elements in each row are shifted to the left by *steps* position\(s\).

-   if *steps* is 0, *X* is not shifted.


## Details {#details}

The `rowMove` function shifts the elements in each row of *X* left or right by a specified number of steps.

## Examples {#examples}

```
m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL])
rowMove(m, 2)          
```

|col1|col2|col3|
|----|----|----|
|||4.5|
|||2.6|
|||1.5|

```
rowMove(m, -2)
```

|col1|col2|col3|
|----|----|----|
|4.9|||
|2|||
||||

```
a=array(INT[], 0, 10).append!([1 2 3, 4 5, 6 7 8]);
rowMove(a, 2)
// output: [[00i,00i,1],[00i,00i],[00i,00i,6]]

tp = [[1.3,2.5,2.3], [4.1,5.3,6.2]]
tp.setColumnarTuple!()
rowMove(tp, -2)
// output: [[2.3,00F,00F],[6.200000000000001,00F,00F]]
```

