# rowMax {#rowmax}

## Syntax {#syntax}

`rowMax(args...)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

Calculate the maximum value of each row of the arguments.

## Examples {#examples}

```
m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL])
rowMax(m);
// output: [4.9,4.8,5.9]

t1=table(1..5 as x, 6..10 as y)
t2=table(5..1 as a, 10..6 as b);

rowMax(t1);
// output: [6,7,8,9,10]

rowMax(t1[`y], t2, take(8, 5));
// output: [10,9,8,9,10]

t=table(`AAPL`MS`IBM`IBM`C as sym, 49.6 29.46 29.52 30.02 174.97 as price1, 175.23 50.76 50.32 51.29 26.23 as price2);
select sym,rowMax(price1,price2) as max from t;
```

|sym|max|
|---|---|
|AAPL|175.23|
|MS|50.76|
|IBM|50.32|
|IBM|51.29|
|C|174.97|

Related function: [max](../m/max.md)

