# rowKurtosis {#rowkurtosis}

## Syntax {#syntax}

`rowKurtosis(X, [biased=true])`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value, indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Return the kurtosis of each row in *X*.

The calculation uses the following formula when *biased*=true:

![](../../images/kurtosisx.png)

## Examples {#examples}

```
m = [4.5 2.6 1.5 1.5 4.8, 5.9 4.9 2.0 4.0 6.3, 2 2 2 2 2, 2.1 3.4 4.2 5.5 2.3]
rowKurtosis(m);
// output: [1.336589711715856,1.839333299961742,2.248755164221374,1.437834622248661,1.341044189891083]

m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL, 4.3 NULL 3.5]);
rowKurtosis(m);
// output: [2.270290894661423,1.499999999999941,1.499999999999972]

t1=table(1..5 as x, 10..6 as y, 15..19 as z, take(3,5) as t);
rowKurtosis(t1);
// output: [1.417974225003112,1.676864,1.951167883478534,2.158698670898631,2.262015004030008]
```

Related function: [kurtosis](../k/kurtosis.md)

