# rowEuclidean {#roweuclidean}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowEuclidean(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric vectors/array vectors of the same length or matrices with the same dimension. If *X* and *Y* are array vectors, the vectors at the same position in *X* and *Y* must have the same length.

## Details {#details}

If both *X* and *Y* are vectors/matrices, calculate the Euclidean distance between *X* and *Y* by row. If both *X* and *Y* are indexed matrices, calculate the Euclidean distance between rows with the same label. For other rows, return NULL.

For a vector and a matrix, the length of the vector must be the same as the number of columns of the matrix. Calculate the Euclidean distance between the vector and each row of the matrix is calculated.

If *X* and *Y* are array vectors, calculate the Euclidean distance between the corresponding rows \(vectors\) in *X* and *Y*, i.e., euclidean\(X.row\(i\),Y.row\(i\)\).

For a vector and an array vector, calculate the Euclidean distance between the vector and each vector in the array vector. Return NULL when *X* and *Y* are of different lengths.

As with all other aggregate functions, null values are ignored in the calculation.

## Examples {#examples}

```
rowEuclidean(3.6 5.2 6.3, 8.6 4.8 5.5)
// output: [5,0.4,0.8]

m=matrix(23 56 47, 112 94 59)
m1=matrix(11 15 89, 52 41 63)
rowEuclidean(m,m1)
// output: [61.1882,67.0075,42.19]

m.rename!(2020.01.01..2020.01.03, `A`B)
m.setIndexedMatrix!()
m1.rename!(2020.01.01 2020.01.03 2020.01.04, `A`B)
m1.setIndexedMatrix!()
rowEuclidean(m,m1)
// output: [61.1882,NULL,36.7151,NULL]

a=array(INT[],0,10)
a.append!([[1, 8, 9],[15, NULL], [25, 22, 13, 15]])
b=array(INT[],0,10)
b.append!([[11, 18, 6],[5, 9], [5, 2, 3, 1]])
rowEuclidean(a,b)
// output: [14.4568,10,33.1059]
```

Related function: [euclidean](../e/euclidean.md)

