# rowDot {#rowdot}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowDot(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric vectors/array vectors of the same length or matrices with the same dimension. If *X* and *Y* are array vectors, the vectors at the same position in *X* and *Y* must have the same length.

## Details {#details}

If both *X* and *Y* are vectors/matrices, calculate the inner product between *X* and *Y* by row. If both *X* and *Y* are indexed matrices, calculate the inner product between rows with the same label. For other rows, return NULL.

For a vector and a matrix, the length of the vector must be the same as the number of columns of the matrix. Calculate the inner product between the vector and each row of the matrix is calculated.

If *X* and *Y* are array vectors, calculate the inner product between the corresponding rows \(vectors\) in *X* and *Y*, i.e., dot\(X.row\(i\),Y.row\(i\)\).

For a vector and an array vector, calculate the inner product between the vector and each vector in the array vector. Return NULL when *X* and *Y* are of different lengths.

As with all other aggregate functions, null values are ignored in the calculation.

## Examples {#examples}

```
rowDot(13.5 15.2 6.3, 18.6 14.8 15.5)
// output: [251.1,224.96,97.65]

s1=indexedSeries(2020.01.01..2020.01.03, 10.4 11.2 9)
s2=indexedSeries(2020.01.01 2020.01.03 2020.01.04, 23.5 31.2 26)
rowDot(s1,s2)
// output: [244.4,349.44,234]

m=matrix(23 56 47, 112 94 59)
m1=matrix(11 15 89, 52 41 63)
rowDot(m,m1)
// output: [6077,4694,7900]

m.rename!(2020.01.01..2020.01.03, `A`B)
m.setIndexedMatrix!()
m1.rename!(2020.01.01 2020.01.03 2020.01.04, `A`B)
m1.setIndexedMatrix!()
rowDot(m,m1)
// output: [6077,NULL,3124,NULL]

a=array(DOUBLE[],0,10)
a.append!([[10.5, 11.8, 9],[15, NULL], [2.5, 2.2, 1.3, 1.5]])
b=array(DOUBLE[],0,10)
b.append!([[1.1, 1.8, 6],[5, 6.9], [3.5, 2, 3, 2.8]])
rowDot(a,b)
// output: [86.79,75,21.25]
```

Related function: [dot](../d/dot.md)

