# rowDenseRank {#rowdenserank}

## Syntax {#syntax}

`rowDenseRank(X, [ascending=true], [ignoreNA=true], [percent=false])`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Arguments {#arguments}

**X** is a matrix.

**ascending** \(optional\) is a Boolean value indicating whether to sort in ascending order. The default value is true.

**ignoreNA** \(optional\) is a Boolean value indicating whether null values are ignored in ranking and return NULL. When Null values participate in ranking, NULL values return 0, which is the smallest value in the result.

**percent** \(optional\) is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

## Details {#details}

`rowDenseRank` can be viewed as function [denseRank](../d/denseRank.md) applied on rows instead of columns. It returns the consecutive rank of each element in each row.

## Examples {#examples}

```
m = matrix(1 5 8 5 9, 2 8 2 5 2, 6 5 3 3 4)
rowDenseRank(m)
```

|col1|col2|col3|
|----|----|----|
|0|1|2|
|0|1|0|
|2|0|1|
|1|1|0|
|2|0|1|

```
y=matrix(1 3 3, 6 5 6, NULL 0 9)
rowDenseRank(y)
```

|col1|col2|col3|
|----|----|----|
|0||1|
|1|2|0|
|0|1|2|

```
rowDenseRank(y, ignoreNA=false)
```

|col1|col2|col3|
|----|----|----|
|1|2|0|
|1|2|0|
|0|1|2|

Related function: [denseRank](../d/denseRank.md), [rowRank](rowRank.md)

