# rowCumsum {#rowcumsum}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowCumsum(X)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

`rowCumsum` calculates the cumulative sum of each row of *X*.

## Examples {#examples}

```
m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL])
rowCumsum(m)
/* output:
col1        col2    col3
4.5     6       10.9
2.6     7.4     9.4
1.5     7.4     7.4
*/

a=array(INT[], 0, 10).append!([1 2 3, 4 5, 6 7 8]);
rowCumsum(a)
// output: [[1,3,6],[4,9],[6,13,21]]

tp = [[1.3,2.5,2.3], [4.1,5.3,6.2]]
tp.setColumnarTuple!()
rowCumsum(tp)
// output: [[1.3,3.8,6.1],[4.1,9.4,15.6]]
```

