# rowCovar {#rowcovar}

## Syntax {#syntax}

`rowCovar(X, Y)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

Calculate the covariance between *X* and *Y* by row and return a vector with the same number of rows of *X*.

## Examples {#examples}

```
m1=matrix(2 8 9 12, 9 14 11 8,-3 NULL NULL 9)
m2=matrix(11.2 3 5 9, 7 -10 8 5,17 12 18 9)
rowCovar(m1, m2)
// output: [-29.7333, -39, 3, 3.3333]

a= 110 112.3 44 98
b= 57.9 39 75 90
c= 55 64 37 78
x=array\(DOUBLE\[\],0, 10\).append!\(\[a, b, c\]\)
y=array\(DOUBLE\[\],0, 10\).append!\(\[b, a, c\]\)

rowCovar\(x, y\)
// output: \[-327.9475, -327.9475, 295\]
```

```
//Define a random data set x

x = rand(1.0, 1000000)

//calculate the covariance between x and sorted x in a sliding window with a user-defined aggregate function
timer moving(defg(x):covar(x, sort(x)), x, 5)
// output: 1928.888 ms

//calculate with rowCovar

timer rowCovar(x[movingWindowIndex(x, 5)], x[movingTopNIndex(x, 5, 5)])
// output: 232.407 ms
```

Related function: [covar](../c/covar.md)

