# rowCorr {#rowcorr}

## Syntax {#syntax}

`rowCorr(X, Y)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

Calculate the correlation between *X* and *Y* by row and return a vector with the same number of rows of *X*. Null values are ignored in calculation.

## Examples {#examples}

```
m1=matrix(2 -1 4, 8 3 2, 9 0 1)
m2=matrix(8 11 10, 8 17 4, 14 6 4)
rowCorr(m1, m2)
// output: [0.61, 0.7559, 0.9449]

m3=matrix(8 NULL 10, 8 NULL 4, 14 NULL NULL)
rowCorr(m1, m3)
// output: [0.61, , 1]

a=array\(DOUBLE\[\], 0, 10\).append!\(\[1 2 3, 4 NULL 5, 6 7 8, NULL 3 10\]\);
b=array\(DOUBLE\[\], 0, 10\).append!\(\[\[1.3,1.2, 4\], \[1.0,1.4, 2\], \[1.1, 1.4, 3\],\[1, 4, 7\]\]\);

rowBeta\(a, b\)
// output: \[0.535, 1 , 0.9105, 2.3333\]
```

Related function: [corr](../c/corr.md)

