# rowAt {#rowat}

## Syntax {#syntax}

`rowAt(X, Y)`

`rowAt(X, [Y])`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Arguments {#arguments}

**X** is a matrix/array vector/columnar tuple.

**Y**\(optional\) can be a vector of integers, a Boolean matrix, a Boolean/integral array vector or columnar tuple.

## Details {#details}

Retrieve the element in each row of X based on the index specified by the corresponding element of Y. Return a vector with the same length as the number of input rows.

-   If *Y* is not specified, *X* must be a Boolean matrix or Boolean array vector. The `rowAt` function retrieves the row indices for each "true" element in *X* by row and returns an array vector \(or columnar tuple\) of integers. The returned result has the same number of rows as *X*. If X contains a row with only null values or "false" elements, `rowAt` returns null for that row.

-   If *Y* is a vector of integers, then each element in *Y* indicates the column index for *X* at each row. The `rowAt` function retrieves the corresponding element at each row in *X* and returns a vector of the same size as *Y*. If no element is found at the position specified by *Y*, a null value is returned. When *Y* is a Boolean matrix, *X* must be a matrix.

-   If *Y* is a Boolean matrix or Boolean array vector \(or columnar tuple\), the `rowAt` function retrieves the elements in *X* that correspond to the "true" values in *Y* and returns an array vector \(or columnar tuple\). The returned result has the same number of rows as *Y*. For any row in *Y* that contains only "false" elements, `rowAt` returns a null value in the output array vector for that row.

-   If *Y* is an array vector \(or columnar tuple\) of integers, then each row in *Y* indicates the column index for *X* at each row. The `rowAt` function retrieves the corresponding element\(s\) at each row in *X* and returns an array vector \(or columnar tuple\) of the same dimension as *Y*. If no element is found at the position specified by *Y*, a null value is returned.


## Examples {#examples}

```
m = matrix(3.1 4.5 2.2, 4.2 4.3 5.1, 6.2 7.1 2.2, 1.8 6.1 5.3, 7.1 8.4 3.5)
index = 4 0 2
rowAt(m, index)
// output: [7.1,4.5,2.2]

trades = table(10:0,`time`sym`p1`p2`p3`p4`p5`vol1`vol2`vol3`vol4`vol5,[TIMESTAMP,SYMBOL,DOUBLE,DOUBLE,DOUBLE,DOUBLE,DOUBLE,INT,INT,INT,INT,INT])
insert into trades values(2022.01.01T09:00:00, `A, 33.2, 33.8, 33.6, 33.3, 33.1, 200, 180, 180, 220, 200)
insert into trades values(2022.01.01T09:00:00, `A, 33.1, 32.8, 33.2, 34.3, 32.3, 150, 280, 190, 100, 220)
insert into trades values(2022.01.01T09:00:00, `A, 31.2, 32.6, 33.6, 35.3, 34.5, 220, 160, 130, 100, 110)
insert into trades values(2022.01.01T09:00:00, `A, 30.2, 32.5, 33.6, 35.3, 34.1, 200, 180, 150, 140, 120)
insert into trades values(2022.01.01T09:00:00, `A, 33.2, 33.8, 33.6, 33.3, 33.1, 180, 160, 160, 180, 200)
select rowAt(matrix(p1, p2, p3, p4, p5), rowImin(vol1, vol2, vol3, vol4, vol5)) as price1, rowAt(matrix(p1, p2, p3, p4, p5), rowImax(vol1, vol2, vol3, vol4, vol5)) as price2 from trades


```

|price1|price2|
|------|------|
|33.8|33.3|
|34.3|32.8|
|35.3|31.2|
|34.1|30.2|
|33.8|33.1|

``` {#codeblock_jxb_nwt_rzb}
index = array(INT[], 0, 10).append!([0 1, 2 4, 3 4 5])
rowAt(m, index)
// output: [[3.1,4.2],[7.1,8.4],[5.3,3.5,]]

x = array(DOUBLE[], 0, 10).append!([3.3 3.6 3.8, 3.7 3.4 3.5, 3.4 3.4 3.5])
index = array(INT[], 0, 10).append!([0 1, 2, 0 2])
rowAt(x, index)
// output: [[3.3,3.6],[3.5],[3.4,3.5]]
```

For version 2.00.10.2 and later, when *X* is a Boolean matrix or array vector, *Y* can be unspecified, and `rowAt` returns the indices of elements that are true in each row.

``` {#codeblock_hsm_bxt_rzb}
m = matrix(true false false, false true false, true true false)
R=rowAt(m)
R
// output: [[0,2],[1,2],]
typestr(R)  
// output: FAST INT[] VECTOR

m = matrix(3.1 4.5 2.2, 2.2 4.3 5.1, 1.2 7.1 2.2, 1.8 6.1 5.3, 1 4 3)
rowAt(m, m>4)
// output: [,[4.5,4.3,7.1,6.1],[5.1,5.3]]

x = array(DOUBLE[], 0, 10).append!([3.3 3.6 3.8, 3.7 3.4 3.5, 3.4 3.4 3.5])
rowAt(x, x>3.5)
// output: [[3.6,3.8],[3.7],]
```

Use `rowAt` on a columnar tuple and an array vector:

``` {#codeblock_rmh_4lj_b1c}
x = ([1, 2, 3], [4, 5, 6]).setColumnarTuple!()
y = fixedLengthArrayVector([1, 4], [2, 5], [3, 6])

rowAt(x, x > 1)        
// output: ([2,3],[4,5,6])

rowAt(y, y>1)           
// output: [[2,3],[4,5,6]]
```

Related functions: [at](../a/at.md)

