# rowAnd {#rowand}

## Syntax {#syntax}

`rowAnd(args...)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

For each row \(a vector is viewed as a one-column matrix here\), return 1 if all rows of all input variables are true; otherwise return 0.

## Examples {#examples}

```
m=matrix([true false false, true true true, true true true])
rowAnd(m);
// output: [1,0,0]

t1=table(false true true true false as x, false true false true true as y)
rowAnd(t1);
// output: [0,1,0,1,0]

t=table(`AAPL`MS`IBM`IBM`C as sym, 49.6 29.46 29.52 30.02 174.97 as price1, 175.23 50.76 50.32 51.29 26.23 as price2)
select *  from t where rowAnd(price1>30, price2>50);
```

|sym|price1|price2|
|---|------|------|
|AAPL|49.6|175.23|
|IBM|30.02|51.29|

Related function: [and](../a/and.md)

