# rollingPanel {#rollingpanel}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rollingPanel(X, window, [groupingCol])`

## Arguments {#arguments}

**X** is a table.

**window** is a positive integer indicating the length of the moving windows.

**groupingCol** \(optional\) is a string scalar/vector indicating one or some columns in table *X*.

## Details {#details}

Extract a fixed number of rows from a table with a rolling window to generate a new table. The rolling window moves by 1 row each time until it reaches the bottom of the table.

If *groupingCol* is specified, perform the aforementioned operation in each group.

The panelNumber column in the result means the index of each extraction operation, which starts from 0.

## Examples {#examples}

```
t=table(1 1 1 1 1 2 2 2 2 2 as id, 1..10 as x);
rollingPanel(t, 3, `id);
```

|id|x|panelNumber|
|---|---|-----------|
|1|1|0|
|1|2|0|
|1|3|0|
|1|2|1|
|1|3|1|
|1|4|1|
|1|3|2|
|1|4|2|
|1|5|2|
|2|6|3|
|2|7|3|
|2|8|3|
|2|7|4|
|2|8|4|
|2|9|4|
|2|8|5|
|2|9|5|
|2|10|5|

