# rms {#rms}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rms(X)`

## Arguments {#arguments}

**X** can be a numeric scalar, pair, vector, matrix, or table.

## Details {#details}

Calculate the root mean square value of input *X*. Its formula is as follows:

![](../images/rms1.png)

**Return Value**

-   If *X* is a scalar, pair, or vector, it returns a scalar.
-   If *X* is a matrix, it returns a vector, with each element representing the RMS value of a column.
-   If *X* is a table, it returns a single-row table, where each column contains the RMS value for that corresponding column.

## Examples {#examples}

Example 1: when *X* is a vector

``` {#codeblock_g5q_gwj_b2c}
X=[1,2,3,4,5]
rms(X)
// output: 3.317
```

Example 2: when *X* is a matix

``` {#codeblock_kkk_gwj_b2c}
X=matrix(1 2 3, 4 5 6)
rms(X)
// output: [2.160,5.066]
```

Example 3: when *X* is a table

``` {#codeblock_km2_gwj_b2c}
X=1 2 3 4 5 6
Y=7 8 9 10 11 12
t=table(X as val1, Y as val2)
rms(t)
```

Output:

|**val1**|**val2**|
|--------|--------|
|3.894|9.652|

