# rmdir {#rmdir}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rmdir(dir, [recursive=false], [keepRootDir=false])`

## Arguments {#arguments}

**directory** is the the path of the directory to be deleted.

**recursive** \(optional\) specifies whether to delete a non-empty directory. The default value is false.

**keepRootDir** \(optional\) is a Boolean value that specifies whether to keep the root directory. The default value is false. When it is set to true, only subdirectories and files are deleted.

**Note:** If *keepRootDir*is set to true, then *recursive*must be set to true.

## Details {#details}

rmdir\(directory\): delete an empty directory.

rmdir\(directory, true\): delete a non-empty directory.

It must be executed by a logged-in user.

## Examples {#examples}

```
files("/home/test");
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|dir1|1|0|1496650004836|1496650004836|
|dir2|1|0|1496650002210|1496650002210|
|dir3|1|0|1496649999597|1496649999597|

```
// delete a directory. dir1 is empty, dir2 is not empty.
rmdir("/home/test/dir1");
rmdir("/home/test/dir2");

Failed to remove directory [/home/test/dir2] with error code 145

// Delete a directory recursively
rmdir("/home/test/dir2", true);

files("/home/test");
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|dir3|1|0|1496649999597|1496649999597|

