# ridgeCV {#ridgecv}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ridgeCV(ds, yColName, xColNames, [alphas], [intercept], [normalize], [maxIter], [tolerance], [solver], [swColName])`

## Arguments {#arguments}

The `ridgeCV` function inherits all parameters of function [ridge](ridge.md), with one added parameter, *alphas*.

**alphas**\(optional\) is a floating-point scalar or vector that represents the coefficient multiplied by the L1 norm penalty term. The default value is \[0.01, 0.1, 1.0\].

## Details {#details}

Perform ridge regression using 5-fold cross-validation and return a model corresponding to the optimal parameters.

**Return value**: A dictionary containing the following keys

-   modelName: the model name, which is "ridgeCV" for this method

-   coefficients: the regression coefficients

-   intercept: the intercept

-   xColNames: the column names of the independent variables in the data source

-   predict: the function used for prediction

-   alpha: the penalty term for cross-validation


## Examples {#examples}

``` {#codeblock_ogv_3sk_21c}
y = [225.720746,-76.195841,63.089878,139.44561,-65.548346,2.037451,22.403987,-0.678415,37.884102,37.308288]
x0 = [2.240893,-0.854096,0.400157,1.454274,-0.977278,-0.205158,0.121675,-0.151357,0.333674,0.410599]
x1 = [0.978738,0.313068,1.764052,0.144044,1.867558,1.494079,0.761038,0.950088,0.443863,-0.103219]
t = table(y, x0, x1);

ridgeCV(t, `y, `x0`x1);

/* output:
coefficients->[94.3410,14.2523]
predict->coordinateDescentPredict
modelName->ridgeCV
xColNames->[x0,x1]
intercept->0.1063
alpha->0.0100
*/
```

