# revokeStreamingSQLTable {#revokeStreamingSQLTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`revokeStreamingSQLTable(tableName)`

## Arguments {#arguments}

**tableName** A STRING scalar indicating the name of the declared streaming SQL table.

## Details {#details}

Revoke a streaming SQL table declared via `declareStreamingSQLTable`.

-   Only the table declared by the current user can be revoked.

-   Before revoking a table, all streaming SQL queries registered on it must be revoked first.

-   This function only removes the streaming SQL feature; the table and its data remain.


**Return value**: None.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st","sql_avg")

// Revoke the registered streaming SQL query
revokeStreamingSQL("sql_avg")

// Revoke the streaming SQL table
revokeStreamingSQLTable(`st)
```

**Related functions:** [declareStreamingSQLTable](../d/declareStreamingSQLTable.md), [listStreamingSQLTables](../l/listStreamingSQLTables.md), [registerStreamingSQL](registerStreamingSQL.md), [revokeStreamingSQL](revokeStreamingSQL.md)

