# restoreSettings {#restoreSettings}

## Syntax {#Syntax.1 .section}

`restoreSettings(fileName, [overwrite=false])`

## Arguments {#Arguments.1 .section}

**fileName**is a STRING scalar specifying the backup file path. It can be an absolute path or relative path to *&lt;HomeDir&gt;*.

**overwrite**\(optional\) is a Boolean scalar indicating whether to overwrite the current settings with the backup setting files.

-   false \(default\): Not to overwrite the current settings. Only new users \(along with permissions\) and function views are added.

-   true: Delete current settings and overwrite with the backup files.


## Details {#Details.1 .section}

Restore settings on users, permissions, and function views with files backed up with `backupSettings` to the current cluster.

This function can only be executed by an administrator on the controller. It can be used with `backupSettings` to back up and restore user settings when migrating databases.

**Return value**: A vector containing all restored user names and function views.

## Examples {#Examples.1 .section}

For a cluster with user A and B, restore permission settings on user A and C.

When *overwrite*=false, add user C and its permission to the cluster:

``` {#codeblock_zpg_dmw_nbc}
restoreSettings(fileName="/home/ddb/backup/permission.back", overwrite=false)
```

When *overwrite*=true, overwrite the user settings in the cluster:

``` {#codeblock_aqg_dmw_nbc}
restoreSettings(fileName="/home/ddb/backup/permission.back", overwrite=true)
```

**Related function**: [backupSettings](../b/backupSettings.md)

**Parent topic:**[Functions](../../Functions/category.md)

