# restoreDislocatedTablet {#restoredislocatedtablet}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`restoreDislocatedTablet()`

## Arguments {#arguments}

None

## Details {#details}

When *enableChunkGranularityConfig*=false \(see details in [Reference *enableChunkGranularityConfig*](../../Database/Configuration/reference.md#)\) all tables in the same partition are distributed in the same node.

When rebalancing data by function [rebalanceChunksAmongDataNodes](rebalanceChunksAmongDataNodes.md), if the node is down, some tables in the same partition may fail to relocate, i.e., different tables under the same partition will be distributed in different nodes. Execute the function to move all tables under the same partition to one node.

Return a table containing the following columns:

|name|meaning|
|----|-------|
|chunkId|the chunk ID|
|srcNode|alias of source node|
|destNode|alias of destination node|

This function can only be executed on the controller.

You can get the status of recovery tasks by [getRecoveryTaskStatus](../g/getRecoveryTaskStatus.md) on a controller.

## Examples {#examples}

```
restoreDislocatedTablet()
```

|ChunkId|srcNode|destNode|
|-------|-------|--------|
|99279094-ca12-3b87-48b6-520cbb986f39|node1|node2|
|45f612b8-42f5-aebd-4cef-e522b6ae1fc8|node1|node2|

