# restore {#restore}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`restore(backupDir, dbPath, tableName, partition, [force=false], [outputTable], [parallel=false], [snapshot=false], [keyPath])`

## Arguments {#arguments}

**backupDir** is a string indicating the directory where the backup is kept.

**dbPath** is a string indicating the path of a DFS database.

**tableName** is a string indicating a DFS table name.

**partition** is a string indicating the relative path of the partitions to be restored. Use "?" as a single wildcard and "%" as a wildcard that can match zero or more characters.

-   To restore all partitions, use "%".

-   To restore a certain partition, specify the relative path or "%" +"partition name". For example, to restore the "20170810/50\_100" partition under "dfs://compoDB", specify "/compoDB/20170807/0\_50" or "%/20170807/0\_50" as partition path.

    For versions between 1.30.16/2.00.4 - 1.30.18/2.00.6, if *chunkGranularity* is set to "TABLE" when creating the database, *partition* must include the physical index \(which you can get with the `listTables` function\) of the selected partition. For example, if the physical index of the "/compoDB/20170807/0\_50" partition is 8t, then specify partition as "/compoDB/20170807/0\_50/8t" to restore it.


**force** \(optional\) is a Boolean value. The default value is false, meaning to perform an incremental recovery, i.e., only the partitions with different metadata from that of the most recent backup are restored. True means to perform a full recovery.

**outputTable** \(optional\) is the handle to a DFS table which has the same schema as the backup table. If it is unspecified, partitions will be restored to the target table specified by *tableName*; Otherwise, partitions will be restored to *outputTable* whereas the table specified by *tableName* remains unchanged.

**parallel** \(optional\) is a Boolean value indicating whether to restore partitions of a table in parallel. The default value is false.

**snapshot** \(optional\) is a Boolean value indicating whether to synchronize the deletion of table/partitions in the backup to the restored database. It only takes effect when *partition* is set to "%". If set to true, the deleted tables/partitions in the backup are deleted in the target restore database synchronously. Note: For versions prior to 2.00.13/3.00.1, the default value for *snapshot* is true. Since version 2.00.13/3.00.1, the default value is false.

**keyPath** \(optional, Linux only\) is a STRING scalar that specifies the path to the key file used for restoring an encrypted backup. The key version used for restoring the data must match the version specified during the backup. Note that when restoring an encrypted table, both the backup table and the target table must use the same encryption mode \(i.e., the same *encryptMode* parameter specified during table creation\).

## Details {#details}

Restore the specified partitions from the most recent backup. Return a string vector indicating the path of restored partitions. The function must be executed by a logged-in user.

Note:

-   To restore the partitions backed up with SQL statements, the parameter *snapshot* should not be true. Otherwise an error is raised.

-   When restoring the partitions backed up with SQL statements, the backup data is directly appended to the target restore table; When restoring the partitions backed up by copying files, the system only overwrites the partitions that have different data.

-   Make sure that the storage engine of the backup database is the same as the engine of *newDBPath*, and the partitionScheme must be the same \(except for VALUE\). For a VALUE partitioned database, the partitioning scheme of the backup database must be a subset of that of the database to be restored. For example, if the partitioning scheme of the backup database is database\("dfs://xxx", VALUE, 2017.08.07..2017.08.11\), then the partitioning scheme of the target database must be VALUE-based and its range must be beyond 2017.08.07..2017.08.11.


## Examples {#examples}

Create a DFS database dfs://compoDB

```
n=1000000
ID=rand(100, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x);

dbDate = database(, VALUE, 2017.08.07..2017.08.11)
dbID=database(, RANGE, 0 50 100);
db = database("dfs://compoDB", COMPO, [dbDate, dbID]);
pt = db.createPartitionedTable(t, `pt, `date`ID)
pt.append!(t);
```

Back up the entire table pt:

```
backup("/home/DolphinDB/backup",<select * from loadTable("dfs://compoDB","pt")>,true);
// output: 10
```

Example 1. Restore the entire table pt:

```
restore("/home/DolphinDB/backup","dfs://compoDB","pt","%",true);
// output: ["dfs://compoDB/20170807/0_50/6F","dfs://compoDB/20170807/50_100/6F","dfs://compoDB/20170808/0_50/6F","dfs://compoDB/20170808/50_100/6F","dfs://compoDB/20170809/0_50/6F","dfs://compoDB/20170809/50_100/6F","dfs://compoDB/20170810/0_50/6F","dfs://compoDB/20170810/50_100/6F","dfs://compoDB/20170811/0_50/6F","dfs://compoDB/20170811/50_100/6F"]
```

Example 2. Restore the partitions in table pt with date=2017.08.10:

```
restore("/home/DolphinDB/backup","dfs://compoDB","pt","%20170810%",true)
// output: ["dfs://compoDB/20170810/0_50/6F","dfs://compoDB/20170810/50_100/6F"]
```

Example 3. Restore the backup of table pt to table temp. Table temp has the same schema as table pt. Note that data loss may occur in table temp when using "%".

```
temp=db.createPartitionedTable(t, `pt, `date`ID);

restore("/home/DolphinDB/backup","dfs://compoDB","pt","%",true,temp);
// output: ["dfs://compoDB/20170807/0_50/6F","dfs://compoDB/20170807/50_100/6F","dfs://compoDB/20170808/0_50/6F","dfs://compoDB/20170808/50_100/6F","dfs://compoDB/20170809/0_50/6F","dfs://compoDB/20170809/50_100/6F","dfs://compoDB/20170810/0_50/6F","dfs://compoDB/20170810/50_100/6F","dfs://compoDB/20170811/0_50/6F","dfs://compoDB/20170811/50_100/6F"]

select count(*) from temp;
```

|count|
|-----|
|1000000|

Related functions: [restoreDB](restoreDB.md), [restoreTable](restoreTable.md), [migrate](../m/migrate.md), [backup](../b/backup.md)

