# residual {#residual}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`residual(Y,X,params,[intercept=true])`

## Arguments {#arguments}

**Y** is the dependent variable. It is a vector.

**X** is the independent variable\(s\). *X* can be a matrix, table or tuple. When *X* is a matrix, if the number of rows is the same as the length of *Y*, each column of *X* is a factor; If the number of columns equals the length of *Y*, each row of *X* is a factor.

**params** is the regression estimator.

**intercept** \(optional\) is a Boolean variable indicating whether to include an intercept in the regression. The default value is true, meaning that the system automatically adds a column of "1" to *X* to generate the intercept.

## Details {#details}

Return the residuals from the least squares regression of *Y* on *X*.

**Note:**

-   For an in-memory table, the residuals can be obtained setting mode=2 in function `ols` or `wls`;

-   For a DFS table, the residuals can only be obtained with function `residual`.


## Examples {#examples}

```
x1=1 3 5 7 11 16 23
x2=2 8 11 34 56 54 100
y=0.1 4.2 5.6 8.8 22.1 35.6 77.2

params=ols(y, x1);
residual(y,x1,params)
// output: [6.634188034188036,3.976923076923078,-1.380341880341881,-4.937606837606838,-5.152136752136756,-8.545299145299146,9.404273504273504]

params1=ols(y, (x1,x2),false);
residual(y,(x1,x2),params1,false)
// output: [-1.941530853763632,-2.556479729553295,-4.923597852949359,-11.809587658969416,-11.098921251860737,-4.0152525111045,13.183836820351686]

x=matrix(1 4 8 2 3, 1 4 2 3 8, 1 5 1 1 5);
p1=ols(1..5, x);
residual(1..5, x,p1);
// output: [-0.474770642201834,0.268348623853214,-0.123853211009174,0.598623853211011,-0.268348623853205]
```

