# reshape {#reshape}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`reshape(obj, [dim])`

## Arguments {#arguments}

**obj** is a vector/matrix.

**dim** \(optional\) is a pair of integers indicating \(row dimension\):\(column dimension\) of the result.

## Details {#details}

Change the dimensions of a matrix and return a new matrix. If *dim* is not specified, reshape *obj* to a vector.

## Examples {#examples}

```
x=1..6;
x=x.reshape(3:2);
x
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
x=x.reshape(2:3);
x
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|1|4|6|

```
x=x.reshape(6:1)
x
```

|\#0|
|---|
|1|
|2|
|3|
|4|
|5|
|6|

```
x.reshape()
// output: [1,2,3,4,5,6]
// reshape x to a vector.
```

