# resetDBDirMeta {#resetdbdirmeta}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`resetDBDirMeta(dbDir)`

## Arguments {#arguments}

**dbDir** is a string in the format of "volumeB/DATABASE", indicating the destination directory to which the database will be moved.

## Details {#details}

When transferring metadata across disk volumes, please call `resetDBDirMeta` to change the DATABASE storage path in the metadata to the destination path before transferring the metadata. This command can only be executed on the data node.

**Note:**

1.  The transfer of metadata across volumes can only be performed on the same node;

2.  Before moving the metadata, make sure that there is no writing process on the current node, all transactions have been completed, and all buffers have been synchronized to the disk.


The procedures to move the metalog \(including CHUNK\_METADATA, DATABASE, IOTRAN\_TYPE and LOG\) from volume A to volume B are as follows:

1.  Execute command `resetDBDirMeta('volumeB/DATABASE')` and shut down the server.

2.  Copy the directories CHUNK\_METADATA, DATABASE, IOTRAN\_TYPE and LOG from VolumeA to VolumeB.

3.  Delete the original directories CHUNK\_METADATA, DATABASE, IOTRAN\_TYPE and LOG from VolumeA.

4.  Modify the configuration parameter *chunkMetaDir* = volumeB/CHUNK\_METADATA and start the server.


