# replace {#replace}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`replace(X, oldValue, newValue)`

## Arguments {#arguments}

**X** is a vector/matrix.

**oldValue** is a scalar indicating the value to be replaced.

**newValue** is a scalar of the same category as *X*, indicating the new value.

## Details {#details}

Replace *oldValue* with *newValue* in *X*. `replace!` is the in-place change version of `replace`.

## Examples {#examples}

```
x=1 1 3;
x=x.replace(1,2);
x
// output: [2,2,3]

m=1..4$2:2;
m
```

|\#0|\#1|
|---|---|
|1|3|
|2|4|

```
m=m.replace(2,1);
m
```

|\#0|\#1|
|---|---|
|1|3|
|1|4|

```
m.replace!(1,6);
```

|\#0|\#1|
|---|---|
|6|3|
|6|4|

