# renameTable {#renametable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`renameTable(dbHandle, tableName, newTableName)`

## Arguments {#arguments}

**dbHandle** is a DFS database handle.

**tableName** is a string indicating a table name. The table can be either a DFS table or a dimension table.

**newTableName** is a string indicating the new table name.

## Details {#details}

Rename a table in a DFS database.

## Examples {#examples}

```
n=1000000
ID=rand(10, n)
x=rand(1.0, n)
t=table(ID, x)
db=database("dfs://hashdb101", HASH,  [INT, 2]);
pt = db.createPartitionedTable(t, `pt, `ID)
pt.append!(t)
renameTable(db, `pt, `pt1)
select count(x) from loadTable(db, `pt1);
// output: 1000000
```

