# rename! {#rename}

## Syntax {#syntax}

`rename!(X, Y, [Z])`

## Arguments {#arguments}

**X** is a vector, regular/indexed matrix, in-memory table, or DFS table\(for OLAP engine only\).

-   When *X* is a vector, *Y* is a string/symbol.
-   When *X* is a matrix, if *Z* is not specified, *Y* is the column lables; if *Z* is specified, *Y* is the row labels and *Z* is the column lables. Column and row labels must match the respective dimensions of *X*. *Y* and *Z* could be data of any types. Note that for an indexed matrix, *Y* and *Z* must be strictly increasing vectors, otherwise an error will be thrown.
-   When *X* is an in-memory table, *Y* and *Z* is a string scalar or vector. If *Z* is not specified, *Y* is new column names starting from the first column on the left; if *Z* is specified, *Y* is the old column names and *Z* is the corresponding new column names. Users should make sure the number of new or old column names be less than or equal to the total number of columns in the table.
-   When *X* is a DFS table, *Y* and *Z* must be a string. If *Z* is not specified, *Y* is new column names starting from the first column on the left; if *Z* is specified, *Y* is the old column names and *Z* is the corresponding new column names. Users should make sure the number of new or old column names be less than or equal to the total number of columns in the table;

## Details {#details}

For a vector, assign a new name.

For a matrix, add or change columns names or row names.

For a table, rename the columns.

## Examples {#examples}

```
k=3 6 9;
k.rename!(`rk);
// output: [3,6,9]

// one way to check name is to use function stat to get the descriptive statistics of data
stat k;
/* output:
Median->6
Avg->6
Min->3
Stdev->3
Count->3
Size->3
Name->rk        // the new name for k
Max->9
*/
```

```
m1=1..9$3:3;
m1
```

|\#0|\#1|\#2|
|---|---|---|
|1|4|7|
|2|5|8|
|3|6|9|

```
m1.rename!(`col1`col2`col3);
```

|col1|col2|col3|
|----|----|----|
|1|4|7|
|2|5|8|
|3|6|9|

```
m1.rename!(1 2 3, `c1`c2`c3);
```

||c1|c2|c3|
|---|---|---|---|
|1|1|4|7|
|2|2|5|8|
|3|3|6|9|

```
// note the new matrix uses the name of k as its column name.
m1 join k;
```

||c1|c2|c3|rk|
|---|---|---|---|---|
|1|1|4|7|3|
|2|2|5|8|6|
|3|3|6|9|9|

```
t1=table(1..3 as x, 4..6 as y, 7..9 as z);
t1
```

|x|y|z|
|---|---|---|
|1|4|7|
|2|5|8|
|3|6|9|

```
t1.rename!(`a`b);
```

**Note:** ​​If the number of columns to be renamed exceeds the number of columns in the target table, the system throws an error.

|a|b|z|
|---|---|---|
|1|4|7|
|2|5|8|
|3|6|9|

```
t1.rename!(`aa`bb`cc);
```

|aa|bb|cc|
|---|---|---|
|1|4|7|
|2|5|8|
|3|6|9|

```
t1.rename!(`bb`cc, `y`z);
```

|aa|y|z|
|---|---|---|
|1|4|7|
|2|5|8|
|3|6|9|

```
t1=table(1..3 as x, 4..6 as y, 7..9 as z, k);
t1
// note the table uses the name of k as its column name.
```

|x|y|z|rk|
|---|---|---|---|
|1|4|7|3|
|2|5|8|6|
|3|6|9|9|

Create an indexed matrix m1:

``` {#codeblock_v2y_rwx_gdc}
m = matrix(1..5, 11..15)
m.rename!(2020.01.01..2020.01.05, `A`B)
m1 = m.setIndexedMatrix!();
```

| |A|B|
|---|---|---|
|2020.01.01|1|11|
|2020.01.02|2|12|
|2020.01.03|3|13|
|2020.01.04|4|14|
|2020.01.05|5|15|

Rename the labels for m1:

``` {#codeblock_yzz_twx_gdc}
m1.rename!( "a" + string(1..5), `A1`A2)
```

| |A1|A2|
|---|---|---|
|a1|1|11|
|a2|2|12|
|a3|3|13|
|a4|4|14|
|a5|5|15|

If *Y* or *Z* is not strictly increasing, an error is thrown.

``` {#codeblock_u3f_wwx_gdc}
m1.rename!( "a" + string(4 6 2 1 3), `A1`A2)
m1.rename!( "a""a", `A1`A2)
//Error: The label of an indexed matrix or series must be in strict ascending order.
```

